/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.core;

import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import lilypuree.decorative_blocks.blocks.BarPanelBlock;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.BonfireBlock;
import lilypuree.decorative_blocks.blocks.BrazierBlock;
import lilypuree.decorative_blocks.blocks.ChainBlock;
import lilypuree.decorative_blocks.blocks.ChandelierBlock;
import lilypuree.decorative_blocks.blocks.LatticeBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.PillarBlock;
import lilypuree.decorative_blocks.blocks.RockyDirtBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.core.DBNames;
import lilypuree.decorative_blocks.core.Registration;
import lilypuree.decorative_blocks.platform.Services;
import lilypuree.decorative_blocks.registration.BlockRegistryObject;
import lilypuree.decorative_blocks.registration.RegistrationProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2404;
import net.minecraft.class_2498;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3614;
import net.minecraft.class_3620;
import net.minecraft.class_4970;

public class DBBlocks {
    private static final RegistrationProvider<class_2248> BLOCK_REGISTRY = RegistrationProvider.get(class_2378.field_11146, "decorative_blocks");
    public static final BlockRegistryObject<class_2248> BONFIRE;
    public static final BlockRegistryObject<class_2248> CHANDELIER;
    public static final BlockRegistryObject<class_2248> BRAZIER;
    public static final BlockRegistryObject<class_2248> SOUL_CHANDELIER;
    public static final BlockRegistryObject<class_2248> SOUL_BRAZIER;
    public static final BlockRegistryObject<class_2248> SOUL_BONFIRE;
    public static final BlockRegistryObject<class_2248> BAR_PANEL;
    public static final BlockRegistryObject<class_2248> LATTICE;
    public static final BlockRegistryObject<class_2248> CHAIN;
    public static final BlockRegistryObject<class_2248> STONE_PILLAR;
    public static final BlockRegistryObject<class_2248> ROCKY_DIRT;
    public static final BlockRegistryObject<class_2404> THATCH;
    public static final ImmutableMap<IWoodType, BlockRegistryObject<BeamBlock>> BEAMS;
    public static final ImmutableMap<IWoodType, BlockRegistryObject<PalisadeBlock>> PALISADES;
    public static final ImmutableMap<IWoodType, BlockRegistryObject<SupportBlock>> SUPPORTS;
    public static final ImmutableMap<IWoodType, BlockRegistryObject<SeatBlock>> SEATS;

    public static void init() {
    }

    public static class_2248 createDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        class_4970.class_2251 woodProperty = class_4970.class_2251.method_9639((class_3614)wood.getMaterial(), (class_3620)wood.getMaterialColor()).method_9632(1.2f).method_9626(wood.getSoundType());
        class_4970.class_2251 palisadeProperty = class_4970.class_2251.method_9639((class_3614)wood.getMaterial(), (class_3620)wood.getMaterialColor()).method_9629(2.0f, 4.0f).method_9626(wood.getSoundType());
        return switch (woodDecorativeBlockType) {
            default -> throw new IncompatibleClassChangeError();
            case WoodDecorativeBlockTypes.BEAM -> new BeamBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.SEAT -> new SeatBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.SUPPORT -> new SupportBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.PALISADE -> new PalisadeBlock(palisadeProperty, wood);
        };
    }

    private static <T extends class_2248> BlockRegistryObject<T> registerBlock(String name, Supplier<T> blockSupplier) {
        return BlockRegistryObject.wrap(BLOCK_REGISTRY.register(name, blockSupplier));
    }

    static {
        class_4970.class_2251 chainProperties = class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_16009).method_9632(4.3f).method_9626(class_2498.field_11533).method_22488();
        class_3614 thatchMaterial = new class_3614.class_3615(class_3620.field_16010).method_15811().method_15806().method_15815().method_15810().method_15813();
        class_4970.class_2251 thatchProperties = class_4970.class_2251.method_9637((class_3614)thatchMaterial).method_9634().method_9640().method_9632(100.0f).method_42327();
        BONFIRE = DBBlocks.registerBlock("bonfire", () -> new BonfireBlock(class_4970.class_2251.method_9639((class_3614)class_3614.field_15943, (class_3620)class_3620.field_16002).method_9634().method_9632(0.0f).method_9626(class_2498.field_11543).method_9631(state -> 15).method_42327()));
        CHANDELIER = DBBlocks.registerBlock("chandelier", () -> new ChandelierBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15924).method_9632(0.3f).method_9626(class_2498.field_11547).method_22488().method_9631(state -> 15), false));
        BRAZIER = DBBlocks.registerBlock("brazier", () -> new BrazierBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15953).method_9632(3.0f).method_9626(class_2498.field_11533).method_9631(state -> (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? 15 : 0).method_22488(), false));
        SOUL_BONFIRE = DBBlocks.registerBlock("soul_bonfire", () -> new BonfireBlock(class_4970.class_2251.method_9639((class_3614)class_3614.field_15943, (class_3620)class_3620.field_16026).method_9634().method_9632(0.0f).method_9626(class_2498.field_11543).method_9631(state -> 14).method_42327()));
        SOUL_CHANDELIER = DBBlocks.registerBlock("soul_chandelier", () -> new ChandelierBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15924).method_9632(0.3f).method_9626(class_2498.field_11547).method_22488().method_9631(state -> 11), true));
        SOUL_BRAZIER = DBBlocks.registerBlock("soul_brazier", () -> new BrazierBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15953).method_9632(3.0f).method_9626(class_2498.field_11533).method_9631(state -> (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? 10 : 0).method_22488(), true));
        BAR_PANEL = DBBlocks.registerBlock("bar_panel", () -> new BarPanelBlock(class_4970.class_2251.method_9639((class_3614)class_3614.field_15953, (class_3620)class_3620.field_16009).method_9632(5.0f).method_9626(class_2498.field_11533).method_22488()));
        LATTICE = DBBlocks.registerBlock("lattice", () -> new LatticeBlock(class_4970.class_2251.method_9639((class_3614)class_3614.field_15932, (class_3620)class_3620.field_15996).method_9632(1.2f).method_9626(class_2498.field_11547).method_22488()));
        CHAIN = DBBlocks.registerBlock("chain", () -> new ChainBlock(chainProperties));
        STONE_PILLAR = DBBlocks.registerBlock("stone_pillar", () -> new PillarBlock(class_4970.class_2251.method_9637((class_3614)class_3614.field_15914).method_9629(1.5f, 6.5f)));
        ROCKY_DIRT = DBBlocks.registerBlock("rocky_dirt", RockyDirtBlock::new);
        THATCH = DBBlocks.registerBlock("thatch", () -> Services.PLATFORM.createThatchFluidBlock(Registration.STILL_THATCH, thatchProperties));
        ImmutableMap.Builder beams = new ImmutableMap.Builder();
        ImmutableMap.Builder palisades = new ImmutableMap.Builder();
        ImmutableMap.Builder supports = new ImmutableMap.Builder();
        ImmutableMap.Builder seats = new ImmutableMap.Builder();
        for (VanillaWoodTypes woodType : VanillaWoodTypes.values()) {
            beams.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.BEAM), () -> (BeamBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.BEAM)));
            palisades.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.PALISADE), () -> (PalisadeBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.PALISADE)));
            supports.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.SUPPORT), () -> (SupportBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.SUPPORT)));
            seats.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.SEAT), () -> (SeatBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.SEAT)));
        }
        BEAMS = beams.build();
        PALISADES = palisades.build();
        SUPPORTS = supports.build();
        SEATS = seats.build();
    }
}

